<?php

namespace App\Http\Controllers;
use App\MovieRequest;
use Auth;
use Illuminate\Http\Request;

class RequestMovieController extends Controller
{
    public function index(){
        $req = MovieRequest::orderBy('id','desc')->paginate(10);
        return view('admin.moviereqindex', compact('req'));
    }
    public function store(Request $request)
{
    
    // Use updateOrCreate to update if the 'mr_name' exists, otherwise create a new entry
    MovieRequest::updateOrCreate(
        // Condition to check if 'mr_name' exists
        ['mr_name' => $request->mr_name],
        // Data to be updated or created
        [
            'name' => $request->name,
            'email' => $request->email,
            'reply_message' => $request->reply_message,
        ]
    );

    return back()->with('updated', __('Your Movie request has been sent successfully'));
}


      
}
